package w83b.w83bUtilidades;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83b.w83bBeans.W83bMigasBean;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;

import com.ejie.general.cargador.CargadorEstaticos;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
/**
 * 
 * @author 
 *
 */
public abstract class W83bCreadorMigas{
	
	private static HashMap hashMapMigas = null;
	
	private static final String COD_APLICACION = Q70ListenerUtils.getApplicationProperty("COD_APLICACION");
	private static final String FILE_PROPERTIES = "/html/datos/migas/" + COD_APLICACION.toLowerCase() + ".def.migas.properties";
	
	 private static void cargadorFicheroMigas(){
		 
		 if (hashMapMigas == null) {
		        hashMapMigas = new HashMap();
		 
		        InputStream input = CargadorEstaticos.class.getResourceAsStream(FILE_PROPERTIES);
		 
		        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
		        List listaLineas = new ArrayList();
		 
		        String line = null;
		       try {
		          while ((line = reader.readLine()) != null){
		        	  if(StringUtils.isNotEmpty(line.trim())&&!line.startsWith("//")){
		        		  listaLineas.add(line);
		        	  }
		          }
		       }
		       catch (IOException e) {
		    	   W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		       } finally {
		         try {
		            input.close();
		         } catch (IOException e) {
		        	 W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		         }
		       }
		       
		       for(int i=0,size=listaLineas.size();i<size;i++){
		    	   String linea = (String)listaLineas.get(i);
		    	   
		    	   String name = linea.substring(0,linea.indexOf("=")).trim();
		    	   String texto = linea.substring(linea.indexOf("=")+1).trim();
		    	   
		    	   String tipo = name.substring(name.indexOf(".")+1);
		    	   name = name.substring(0,name.indexOf("."));
		    	   
		    	   W83bMigasBean miga = new W83bMigasBean();//NOPMD
		    	   if(null!=hashMapMigas.get(name)){
		    		  miga = (W83bMigasBean)hashMapMigas.get(name);
		    	   }
		    	   miga.setNombre(name);
		    	   if("url".equals(tipo)){
		    		   miga.setUrl(texto);
		    	   }else if("texto".equals(tipo)){
		    		   miga.setText(texto);
		    	   }else{
		    		   miga.setFunction(texto);
		    	   }
		    	   
		    	   hashMapMigas.put(name, miga);		    	   
		       }			      
		 }
	
	 }
	 
	 public static String generarMigas(String miga,String idioma){
		 StringBuffer htmlMiga = new StringBuffer();
		 
		 cargadorFicheroMigas();
		 
		 String[] listMigas = miga.split("\\.");
		 try{
			 for(int i=0,size=listMigas.length;i<size;i++){
				 String keyMiga = listMigas[i];
				 W83bMigasBean migaBean = (W83bMigasBean)hashMapMigas.get(keyMiga);
				 
				 try {
					 
					if(i+1!=listMigas.length){
						String href = "";
						
						if(StringUtils.isNotEmpty(migaBean.getFunction())){
							href = "javascript:"+migaBean.getFunction()+"('"+migaBean.getUrl()+"')";
						}else{
							href = migaBean.getUrl();
						}
						htmlMiga.append("&nbsp;<a href=\""+href+"\">"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun",migaBean.getText(),idioma)+"</a>");
						htmlMiga.append(">&nbsp;");
					}else{
						htmlMiga.append("&nbsp;"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun",migaBean.getText(),idioma)+"");					
					}
				} catch (Q70GestorMensajesException e) {
					
					W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
					htmlMiga.append("");
				} 
			 }
		 }catch (Exception e) {
			 new Exception("Se ha producido un error en la generacin de migas. Mirar a ver si existe la miga en el properties de migas. Miga: "+miga).printStackTrace();
			 htmlMiga.append("");
			// TODO: handle exception
		}
		 
		 return htmlMiga.toString();		 
	 }	 
}


